<?PHP

// @codingStandardsIgnoreFile

# legacy globals
global $AF;
global $SysConfig;
global $G_SysConfig;
global $G_PluginManager;
global $DB;
global $User;
global $G_User;
global $Session;


# handle calling of AddJavascript() functions at correct point
global $COMPAT_AddJavascriptHooked;
if (!isset($COMPAT_AddJavascriptHooked))
{
    function COMPAT_CallAddJavascript()
    {
        if (function_exists("AddJavascript"))
        {
            AddJavascript();
        }
    }
    $COMPAT_AddJavascriptHooked = TRUE;
    $GLOBALS["AF"]->HookEvent(
            "EVENT_HTML_FILE_LOAD_COMPLETE", "COMPAT_CallAddJavascript");
}

if (!function_exists("GetActiveUI")) {
function GetActiveUI()
{
    global $G_User;
    global $G_SysConfig;

    # if user is logged in and multiple UIs are allowed or user is sys admin
    if ($G_User->IsLoggedIn() && ($G_SysConfig->AllowMultipleUIsEnabled()
            || $G_User->HasPriv(PRIV_SYSADMIN)))
    {
        # use UI selected by user
        $ActiveUI = $G_User->Get("ActiveUI");

        # is user's UI was null, use default system UI
        if (is_null($ActiveUI))
        {
            $ActiveUI = $G_SysConfig->DefaultActiveUI();
        }
    }
    else
    {
        # use default system UI
        $ActiveUI = $G_SysConfig->DefaultActiveUI();
    }

    # correct for old name of default interface
    if ($ActiveUI == "SPTUI--CWIS") {  $ActiveUI = "default";  }

    # return active interface to caller
    return $ActiveUI;
}
}

if (!function_exists("FindUIFile")) {
function FindUIFile($FileName)
{
    # bail out if common HTML requested because ApplicationFramework already loaded it
    if ($FileName == "include/SPT--Common.html") {  return "include/DummyFile.php";  }

    # strip off known prefix and suffix issues
    $FileName = preg_replace(array(
            "/^include\//", "/\.html$/", "/SPT--/"), "", $FileName);

    # ask application framework to find file and return result to caller
    return $GLOBALS["AF"]->GUIFile($FileName);
}
}

if (!function_exists("SoftwareIsCWIS")) {
function SoftwareIsCWIS()
{
    return TRUE;
}
}

if (!function_exists("getmicrotime")) {
function getmicrotime()
{
    return microtime(TRUE);
}
}

if (!function_exists("GetScriptFileName")) {
function GetScriptFileName()
{
    return basename(GetFullScriptFileName());
}
}

if (!function_exists("GetFullScriptFileName")) {
function GetFullScriptFileName()
{
    if (isset($_SERVER["PATH_TRANSLATED"])
             && strlen($_SERVER["PATH_TRANSLATED"]))
    {
        $ScriptFileName = $_SERVER["PATH_TRANSLATED"];
    }
    elseif (isset($_SERVER["SCRIPT_FILENAME"])
             && strlen($_SERVER["SCRIPT_FILENAME"]))
    {
        $ScriptFileName = $_SERVER["SCRIPT_FILENAME"];
    }
    elseif (isset($_SERVER["PATH_INFO"])
             && strlen($_SERVER["PATH_INFO"]))
    {
        $ScriptFileName = $_SERVER["PATH_INFO"];
    }
    else
    {
        exit("ERROR:  unable to determine script file name (GetScriptFileName())");
    }
    return $ScriptFileName;
}
}

if (!function_exists("GetSavedSearchesForUser")) {
function GetSavedSearchesForUser($UserId)
{
    $SSFactory = new SavedSearchFactory();
    return $SSFactory->GetSearchesForUser($UserId);
}
}

if (!function_exists("GetSavedSearchesDueToRun")) {
function GetSavedSearchesDueToRun($UserId)
{
    $SSFactory = new SavedSearchFactory();
    return $SSFactory->GetSearchesDueToRun($UserId);
}
}

if (!function_exists("NeatlyTruncateString")) {
function NeatlyTruncateString($String, $MaxLength, $BreakAnywhere=FALSE)
{
    return StdLib::NeatlyTruncateString($String, $MaxLength, $BreakAnywhere);
}
}

if (!function_exists("ReachedWithAjax")) {
function ReachedWithAjax()
{
    return ApplicationFramework::ReachedViaAjax();
}
}

if (!function_exists("BeginAjaxResponse")) {
function BeginAjaxResponse()
{
    # log calls to this function so that we can find and destroy them
    $GLOBALS["AF"]->LogMessage(
        ApplicationFramework::LOGLVL_INFO,
        "Call to BeginAjaxResponse() in StdLib.php");

    # call the proper function, using the HTML response type because
    # it doesn't set any output suppression or content-type headers
    $GLOBALS["AF"]->BeginAjaxResponse("HTML");
}
}

if (!function_exists("GetCurrentThemeDir")) {
function GetCurrentThemeDir()
{
    # return configured theme
    return $GLOBALS["SysConfig"]->CurrentTheme();
}
}

if (!function_exists("GetActiveUIOptionList")) {
function GetActiveUIOptionList($Selected)
{
    # start out with an empty list
    $Text = "";

    foreach ($GLOBALS["AF"]->GetUserInterfaces() as $CanonicalName => $Label)
    {
        # add the beginning of the opening tag and value
        $Text .= '<option value="'.defaulthtmlentities($CanonicalName).'"';

        # add a selected attribute if the interface is the selected one
        if ($CanonicalName == $Selected)
        {
            $Text .= ' selected="selected"';
        }

        # close off the beginning tag, add the label, and add the closing tag
        $Text .= '>'.defaulthtmlentities($Label).'</option>';
    }

    # return list to caller
    return $Text;
}
}

if (!function_exists("InMetadataTool")) {
function InMetadataTool()
{
    if ((strstr($_SERVER["SCRIPT_NAME"], "/MetadataTool/")
                    && (strstr($_SERVER["SCRIPT_NAME"],
                     "SPT--ImportData") == FALSE)
                    && (strstr($_SERVER["SCRIPT_NAME"],
                     "SPT--EditControlledNameTypes") == FALSE))
            || (strstr($_SERVER["SCRIPT_NAME"],
                    "SPT--BrowseResources.php") && $GLOBALS["Editing"])
            || (strstr($_SERVER["SCRIPT_NAME"],
                    "SPT--Advanced.php") && $GLOBALS["Editing"])
            || (strstr($_SERVER["SCRIPT_NAME"],
                    "SPT--AdvancedSearch.php") && $GLOBALS["Editing"]))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}
}

if (!function_exists("safehtmlentities")) {
function safehtmlentities($string, $quote_style=ENT_COMPAT, $charset="ISO-8859-1",
                          $double_encode=TRUE)
{
    # ignore $double_encode param if php version < 5.2.3
    if (version_compare(phpversion(), "5.2.3", "<"))
    {
        return htmlentities($string, $quote_style, $charset);
    }

    return htmlentities($string, $quote_style, $charset, $double_encode);
}
}

if (!function_exists("safehtmlspecialchars")) {
function safehtmlspecialchars($string, $quote_style=ENT_COMPAT, $charset="ISO-8859-1",
                              $double_encode=TRUE)
{
    # ignore $double_encode param if php version < 5.2.3
    if (version_compare(phpversion(), "5.2.3", "<"))
    {
        return htmlspecialchars($string, $quote_style, $charset);
    }

    return htmlspecialchars($string, $quote_style, $charset, $double_encode);
}
}

if (!function_exists("GetHtmlTranslatedString")) {
function GetHtmlTranslatedString($Value)
{
    return defaulthtmlspecialchars($Value);
}
}

if (!function_exists("UserIsLoggedIn")) {
function UserIsLoggedIn()
{
    return $GLOBALS["G_User"]->IsLoggedIn();
}
}

if (!function_exists("OurHttpProtocol")) {
function OurHttpProtocol()
{
    return isset($_SERVER["HTTPS"]) ? "https:" : "http:";
}
}

if (!function_exists("OurUrl")) {
function OurUrl()
{
    $Protocol = OurHttpProtocol() . "//";
    $Url = $Protocol.(($_SERVER["SERVER_NAME"] != "127.0.0.1")
                ? $_SERVER["SERVER_NAME"]
                : $_SERVER["HTTP_HOST"])
            .$_SERVER["SCRIPT_NAME"];
    return $Url;
}
}

if (!function_exists("OurBaseUrl")) {
function OurBaseUrl()
{
    $Protocol = OurHttpProtocol() . "//";
    $BaseUrl = $Protocol.(($_SERVER["SERVER_NAME"] != "127.0.0.1")
                ? $_SERVER["SERVER_NAME"]
                : $_SERVER["HTTP_HOST"])
            .dirname($_SERVER["SCRIPT_NAME"]);
    if (substr($BaseUrl, -1) != "/")
    {
        $BaseUrl .= "/";
    }
    return $BaseUrl;
}
}

if (!function_exists("OurBasePath")) {
function OurBasePath()
{
    $BasePath = dirname($_SERVER["SCRIPT_NAME"]);

    if (substr($BasePath, -1) != "/")
    {
        $BasePath .= "/";
    }

    return $BasePath;
}
}
