<?PHP

$GLOBALS["G_ErrMsgs"] = SiteUpgrade401_PerformUpgrade();

/**
* Perform all of the site upgrades for 4.0.1
* @return Returns NULL on success and an array of error messages otherwise.
*/
function SiteUpgrade401_PerformUpgrade()
{
    try
    {
        Msg(1, "Migrating Saved Search settings into Saved Search Mailings plugin...");
        SiteUpgrade401_SavedSearchMailings();

    }
    catch (Exception $Exception)
    {
        return array($Exception->getMessage(),
                "Exception Trace:<br/><pre>"
                        .$Exception->getTraceAsString()."</pre>");
    }
}

/**
* Migrate settings for saved search mailings into plugin.
*/
function SiteUpgrade401_SavedSearchMailings()
{
    $DB = new Database();

    # check if sysconfig table has the saved searches setting
    # if it does not, then we've been run already and should exit.
    if (!$DB->FieldExists("SystemConfiguration", "UserAgentsEnabled"))
    {
        return;
    }

    $SavedSearchEnabled = $GLOBALS["G_SysConfig"]->Value(
        "UserAgentsEnabled");

    if ($SavedSearchEnabled)
    {
        # enable the ss mailing plugin
        $GLOBALS["G_PluginManager"]->PluginEnabled("SavedSearchMailings", TRUE);

        $SSPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("SavedSearchMailings", TRUE);

        # get the currently configured template
        $SSTemplate = $GLOBALS["G_SysConfig"]->Value(
            "SavedSearchMailTemplate");

        # if it wasn't "Default"
        if ($SSTemplate != -1)
        {
            # configure the plugin to use it
            $SSPlugin->ConfigSetting(
                "EmailTemplate_".MetadataSchema::SCHEMAID_DEFAULT,
                $SSTemplate);
        }
    }

    # drop the ss configuration columns from the database
    $DB->Query(
        "ALTER TABLE SystemConfiguration DROP COLUMN UserAgentsEnabled");
    $DB->Query(
        "ALTER TABLE SystemConfiguration DROP COLUMN SavedSearchMailTemplate");
}
