<?PHP
#
#   FILE:  AddClassificationComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------


# check if current user is authorized
if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

$Submit = $_POST["Submit"];
$F_FieldId = $_POST["F_FieldId"];
$F_ParentId = $_POST["F_ParentId"];
$F_NewSegmentName = $_POST["F_NewSegmentName"];

# declare Class for use later
$Class = NULL;

if (isset($_POST["F_QualifierId"])) {
    $F_QualifierId = $_POST["F_QualifierId"]; }
else {
    $F_QualifierId = NULL; }

if (is_null($F_QualifierId) || $F_QualifierId == "--") {
    $F_QualifierId = "NULL"; }

# if add classification was requested
if ($Submit != "Cancel")
{
    # if new classification segment name is valid
    $F_NewSegmentName = trim($F_NewSegmentName);
    if (strlen($F_NewSegmentName) > 0)
    {
        # get full name for potential new classification
        if ($F_ParentId == Classification::NOPARENT)
        {
            $NewFullName = $F_NewSegmentName;
        }
        else
        {
            $ParentClass = new Classification($F_ParentId);
            $NewFullName = $ParentClass->Name()." -- ".$F_NewSegmentName;
        }

        # if classification already exists
        $CFactory = new ClassificationFactory($F_FieldId);
        if ($CFactory->NameIsInUse($NewFullName))
        {
            # set error message about name already in use
            $ErrorMessages = new ErrorList();
            $ErrorMessages->AddMessage(
                    "A classification with that name already exists.");
        }
        else
        {
            # add new classification
            $Class = Classification::Create(
                    $F_NewSegmentName, $F_FieldId, $F_ParentId);

            # add qualifier ID (if any)
            if (isset($F_QualifierId) && strlen($F_QualifierId))
            {
                $Class->QualifierId($F_QualifierId);
            }
        }
    }
    else
    {
        # add message to error list
        $ErrorMessages = new ErrorList();
        $ErrorMessages->AddMessage(
                "No classification segment name was supplied.");
    }
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $_SESSION["ErrorMessages"] = $ErrorMessages;
    $AF->SetJumpToPage("AddClassification&ParentId=".$F_ParentId
                    ."&FieldId=".$F_FieldId);
}
else
{
    # set parent ID to classification if it is top level, otherwise it's parent
     $ParentIdForUrl = $F_ParentId && isset($Class) ? $Class->Id() : $F_ParentId;

    # go to classification selection page for parent of edited classification
    $AF->SetJumpToPage("EditClassifications&FieldId=".$F_FieldId
                       ."&ParentId=".$ParentIdForUrl);
}
