<?PHP
#
#   FILE:  ForumTopics.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Forums Topics");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (!$GLOBALS["G_SysConfig"]->ForumsEnabled())
{
    CheckAuthorization(-1);
}

# obtain useful info for this forum
if (isset($_POST["ForumId"]))
{
    $ForumId = intval($_POST["ForumId"]);
}
else if (isset($_GET["FI"]))
{
    $ForumId = intval($_GET["FI"]);
}
else if (isset($_SESSION["ForumId"]))
{
    # redirect to this page to use GET parameters since the session ones won't
    # exist if someone refreshes or clicks a link and clicks the back button
    $AF->SetJumpToPage("index.php?P=ForumTopics&FI="
        .$_SESSION["ForumId"]);
    unset($_SESSION["ForumId"]);
    return;
}

if (isset($ForumId))
{
    $Forum = new Forum($ForumId);

    $H_ForumId = $ForumId;
    $H_ForumName = $Forum->ForumName();
    $H_ForumDescription = $Forum->ForumDescription();
    $H_TopicCount = $Forum->TopicCount();
    $H_MessageCount = $Forum->MessageCount();
    $H_ModeratorId = $Forum->ModeratorId();
    $H_ModeratorName = $Forum->ModeratorName();
    $H_ModeratorEmail = $Forum->ModeratorEmail();
    $H_Topics = $Forum->GetTopicList();
}
