<?PHP
#
#   FILE:  ImportData.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Print error message if there is one.
*/
function PrintErrorMessage()
{
    if (isset($_SESSION["ErrorMessage"]))
    {
        $ErrorMessage = $_SESSION["ErrorMessage"];
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

/**
* Print a html option list of the unique field.
*/
function PrintUniqueFieldList()
{
    $Values = array();

    # first entry is empty
    $Values["-1"] = "None Selected";

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(
        MetadataSchema::MDFTYPE_TEXT |
        MetadataSchema::MDFTYPE_PARAGRAPH |
        MetadataSchema::MDFTYPE_NUMBER |
        MetadataSchema::MDFTYPE_URL );

    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            $Values[$Field->Name()] = $Field->Name();
        }
    }

    $OptList = new HtmlOptionList("F_UniqueField", $Values, "-1");
    $OptList->PrintIfEmpty(FALSE);
    $OptList->PrintHtml();


}

PageTitle("Import Data");

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

# register post-processing function with the application framework
$AF->AddPostProcessingCall("PostProcessingFn");

/**
* Post-processing call.
*/
function PostProcessingFn()
{
    if (isset($_SESSION["ErrorMessage"]))
    {
        unset($_SESSION["ErrorMessage"]);
    }
}
