<?PHP
#
#   FILE:  ListSavedSearches.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization()) {  return;  }
PageTitle("Manage Saved Searches");

# if user asked to save new search
if (isset($_POST["Submit"]) && $_POST["Submit"] == "Save")
{
    # if reasonable search name was supplied
    if (isset($_POST["F_SearchName"]) && strlen(trim($_POST["F_SearchName"])))
    {
        $SearchParams = new SearchParameterSet();
        $SearchParams->UrlParameters($_GET);

        if ($GLOBALS["G_PluginManager"]->PluginEnabled("SavedSearchMailings"))
        {
            $Frequency = $_POST["F_Frequency"];
        }
        else
        {
            $Frequency = SavedSearch::SEARCHFREQ_NEVER;
        }

        # save search
        $NewSavedSearch = new SavedSearch(
            NULL,
            $_POST["F_SearchName"],
            $GLOBALS["G_User"]->Id(),
            $Frequency,
            $SearchParams);
    }
    else
    {
        # set error message and return back to new saved search page
        $_SESSION["ErrorMessage"] = "ERROR: No name was supplied for the saved search.";
        $SearchParams = new SearchParameterSet();
        $SearchParams->UrlParameters($_GET);
        $GLOBALS["AF"]->SetJumpToPage(
            "NewSavedSearch&".$SearchParams->UrlParameterString());
        return;
    }
}

# else if user asked to delete search
elseif (isset($_GET["AC"]) && ($_GET["AC"] == "Delete"))
{
    # delete specified search
    $Search = new SavedSearch($_GET["SI"]);
    $Search->Delete();
}