<?PHP
#
#   FILE:  Preferences.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Print messages about successful save of preferences.
*/
function PrintSuccessMessages()
{
    global $SuccessMessages;

    # if messages were passed from PreferencesComplete
    if (is_array($SuccessMessages))
    {
        foreach ($SuccessMessages as $Message)
        {
            PrintSuccessMessage($Message);
        }
    }
}

/**
* Print messages about errors encountered with preferences.
*/
function PrintErrorMessages()
{
    global $ErrorMessages;
    global $SuccessMessages;

    # if error messages were passed from PreferencesComplete
    if (is_array($ErrorMessages))
    {
        if (function_exists("PrintErrorMessage"))
        {
            foreach ($ErrorMessages as $Message)
            {
                PrintErrorMessage($Message);
            }
        }

        # backwards compatibility
        else
        {
            $AllMessages = (is_array($SuccessMessages))
                ? array_merge($ErrorMessages, $SuccessMessages) : $ErrorMessages;

            # print error messages
            print("<ul>\n");

            foreach ($AllMessages as $Message)
            {
                printf("<li>%s</li>\n", $Message);
            }

            print("</ul>\n");
        }
    }
}

/**
* Print an HTML option list of available user interfaces, with the user's
* currently-selected interface (if available) or the defaul system interface
* selected.
*/
function PrintActiveUIOptionList()
{
    # the user has an active UI set
    if ($GLOBALS["G_User"]->Get("ActiveUI"))
    {
        $Selected = $GLOBALS["G_User"]->Get("ActiveUI");
    }
    # otherwise use the system default
    else
    {
        $Selected = $GLOBALS["G_SysConfig"]->DefaultActiveUI();
    }

    # print option list for UI
    $Options = $GLOBALS["AF"]->GetUserInterfaces();
    $OptList = new HtmlOptionList("F_ActiveUI", $Options, $Selected);
    $OptList->PrintHtml();
}

/**
* Print an HTML option list of possible search results per page, with the user's
* currently-selected setting (if available) or the defaul system setting
* selected.
*/
function PrintSearchResultsPerPageOptionList()
{
    $Selected = NULL;
    if ($GLOBALS["G_User"]->IsLoggedIn())
    {
        $Selected = $GLOBALS["G_User"]->Get("RecordsPerPage");
    }
    if (is_null($Selected))
    {
        $Selected = $GLOBALS["G_SysConfig"]->DefaultRecordsPerPage();
    }

    $Options = array(5 => 5, 10 => 10, 20 => 20, 30 => 30, 50 => 50, 100 => 100);
    $OptList = new HtmlOptionList("F_SearchResultsPerPage", $Options, $Selected);
    $OptList->PrintHtml();
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $SuccessMessages;
global $H_ReturnTo;

$H_ReturnTo = GetArrayValue($_POST, "F_ReturnTo",
        GetArrayValue($_GET, "ReturnTo",
                GetArrayValue($_SERVER, "HTTP_REFERER")));

PageTitle("User Preferences");

# make sure the user is authorized to view the page
if (!$GLOBALS["G_User"]->IsLoggedIn())
{
    CheckAuthorization(FALSE);
    return;
}

# get error messages saved in the session
if (isset($_SESSION["ErrorMessages"]))
{
    $ErrorMessages = $_SESSION["ErrorMessages"];
    unset($_SESSION["ErrorMessages"]);
}

if (isset($_SESSION["SuccessMessages"]))
{
    $SuccessMessages = $_SESSION["SuccessMessages"];
    unset($_SESSION["SuccessMessages"]);
}

# update timestamps as required
$Schema = new MetadataSchema(MetadataSchema::SCHEMAID_USER);
$TimestampFields = $Schema->GetFields(MetadataSchema::MDFTYPE_TIMESTAMP);
$Resource = $GLOBALS["G_User"]->GetResource();
foreach ($TimestampFields as $Field)
{
    if ($Field->UpdateMethod() ==
        MetadataField::UPDATEMETHOD_ONRECORDEDIT)
    {
        $Resource->Set($Field->Name(), "now");
    }
}
