<?PHP
#
#   FILE:  PurgeSampleDataExecute.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

PageTitle("Purge Sample Data");
$DB = new Database();
$Schema = new MetadataSchema();

# check for cancel button
if ($_POST["Submit"] == "Cancel")
{
    $AF->SetJumpToPage("index.php?P=SysAdmin");
    return;
}

# dump out all necessary fields for all records
$RFactory = new ResourceFactory();
$ResourceList = $RFactory->GetItemIds(
    "INSTR(Description, '[--SAMPLE RECORD--]') > 0 OR "
    ."INSTR(Description, '[SCOUT PORTAL TOOLKIT SAMPLE RECORD]') > 0");

$ResourceCount = 0;
$ClassIds = array();
$CNIds = array();

$CreatorField = $Schema->GetFieldByName("Creator");
$PublisherField = $Schema->GetFieldByName("Publisher");

foreach ($ResourceList as $ResourceId)
{
    $Resource = new Resource($ResourceId);

    # get Classifications associated with this Resource
    $Names = $Resource->Classifications();
    foreach ($Names as $ClassificationType => $ClassificationTypes)
    {
        foreach ($ClassificationTypes as $ClassId => $Classification)
        {
            $ClassIds[$ClassId] = $Classification;
        }
    }

    if ($CreatorField)
    {
        # get ControlledNames associated with this Resource
        $Creators = $Resource->Get($CreatorField);
        foreach ($Creators as $CNId => $Creator)
        {
            $CNIds[$CNId] = $Creator;
        }
    }

    if ($PublisherField)
    {
        $Publishers = $Resource->Get($PublisherField);
        foreach ($Publishers as $CNId => $Publisher)
        {
            $CNIds[$CNId] = $Publisher;
        }
    }

    $DB->Query("DELETE FROM ResourceRatings "
               ."WHERE ResourceId=".intval($Resource->Id()));

    $Resource->Delete();
    $ResourceCount++;
}

# post-process classification ids
$ClassificationCount = 0;
foreach ($ClassIds as $ClassId => $Classification)
{
    # delete classification if no resources assigned
    try
    {
        $Class = new Classification($ClassId);
        $ClassificationCount += $Class->Delete(TRUE);
    }
    catch (Exception $Ex)
    {
        $Class = NULL;
    }
}

# post-process controlledname ids
$ControlledNameCount = 0;
foreach ($CNIds as $CNId => $Dummy)
{
    # see if any resources are still using this controlled name
    $CN = new ControlledName($CNId);

    # controlled name not in use, so delete it
    if (!$CN->InUse())
    {
        $CN->Delete();
        $ControlledNameCount++;
    }
}
