<?PHP
#
#   FILE:  RenameMetadataFieldGroup.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Print the fields in the given metadata field group.
 * @param MetadataFieldGroup $Group metadata field group
 * @return void
 */
function PrintGroupItems(MetadataFieldGroup $Group)
{
    foreach ($Group->GetFields() as $Field)
    {
        PrintFieldInGroup($Field);
    }
}

# ----- MAIN -----------------------------------------------------------------

global $SchemaId;
global $Group;

PageTitle("Rename Metadata Field Group");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$SchemaId = GetArrayValue($_GET, "SchemaId", MetadataSchema::SCHEMAID_DEFAULT);
$GroupId = GetArrayValue($_GET, "GroupId");

try
{
    $Group = new MetadataFieldGroup($GroupId);
}

catch (Exception $Exception)
{
    $AF->SetJumpToPage("MetadataFieldOrdering");
}
