<?PHP
#
#   FILE:  ResendAccountActivation.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2006-2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# retrieve user name or e-mail address from URL or form
$H_UserName = GetFormValue("F_UserName", GetFormValue("UN"));
$H_EMailAddress = GetFormValue("F_EMailAddress", GetFormValue("EM"));

# values intended for use in HTML
$H_EMailAddressUsed = FALSE;
$H_UserFound = FALSE;
$H_EMailSent = FALSE;
$H_AccountAlreadyActivated = FALSE;

# if user name was supplied
$TargetUser = NULL;
if (strlen($H_UserName))
{
    # attempt to find user with specified name
    $H_UserName = User::NormalizeUserName($H_UserName);
    $TargetUser = new SPTUser($H_UserName);
}
# else if e-mail address was supplied
elseif (strlen($H_EMailAddress))
{
    # attempt to find user with specified e-mail address
    $Factory = new CWUserFactory();
    $H_EMailAddress = User::NormalizeEMailAddress($H_EMailAddress);
    $TargetUser = $Factory->GetMatchingUsers($H_EMailAddress, "EMail");

    # set flag indicating that we used e-mail address
    $H_EMailAddressUsed = TRUE;
}

# if requested user was found
if ($TargetUser && ($TargetUser->Status() == U_OKAY))
{
    # set flag indicating that user was found
    $H_UserFound = TRUE;

    # if user account was already activated
    if ($TargetUser->IsActivated())
    {
        # set flag indicating account already activated
        $H_AccountAlreadyActivated = TRUE;
    }
    else
    {
        $MailTemplate = $GLOBALS["G_SysConfig"]->PasswordMailSubject()."\n"
                      .$GLOBALS["G_SysConfig"]->PasswordMailBody();
        $FromAddress = $GLOBALS["G_SysConfig"]->PortalName()
                ." <".$GLOBALS["G_SysConfig"]->AdminEmail().">";
        $TargetUser->SendEMail($MailTemplate, $FromAddress,
                      UserEditingUI::GetActivationEmailSubstitutions($TargetUser));

        $H_EMailErrorCode = $TargetUser->Status();
        $H_EMailSent = ($H_EMailErrorCode == U_OKAY) ? TRUE : FALSE;
    }
}
