<?PHP
#
#   FILE:  NotifySubscribers.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Notify Blog Subscribers");

# get the blog plugin and entry
$Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$Entry = new Blog_Entry(GetArrayValue($_GET, "ID"));

# don't allow unauthorized access
if (!$Entry->UserCanEdit($GLOBALS["G_User"]))
{
    CheckAuthorization(FALSE);
    return;
}

# don't notify if the entry is not from the Email Blog
$EntryBlogId = $Entry->GetBlogId();
if ($Blog->ConfigSetting("EmailNotificationBlog") != $EntryBlogId)
{
    $GLOBALS["AF"]->SetJumpToPage("index.php?P=P_Blog_Entry&EntryId="
            . $Entry->Id() . "&Error=ERROR_NOT_EMAIL_BLOG");
    return;
}

# notify subscribers
$Blog->NotifySubscribers($Entry);

# go back to the page for the blog entry
$GLOBALS["AF"]->SetJumpToPage($Entry->EntryUrl());
