<?PHP
#
#   FILE:  Information.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Print the given subscriber list.
 * @param array $Subscribers subscriber list
 */
function PrintSubscribers(array $Subscribers)
{
    foreach ($Subscribers as $Email => $Info)
    {
        PrintSubscriber($Email, $Info);
    }
}

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

PageTitle("Mailing List Information");

$MyPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("MailingList");

global $H_Lists, $H_List;
$H_Lists = $MyPlugin->GetAllLists();

$H_List = (isset($_GET["F_List"])) ?
    $_GET["F_List"] :
    current($H_Lists);

$Statistics = $MyPlugin->GetStatistics($H_List);

# If we have subscriber metrics, make a plot of them:
if ( $GLOBALS["G_PluginManager"]->PluginEnabled("MetricsRecorder") )
{
    $Recorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
    $Data = $Recorder->GetEventData("MailingList", "NumberOfSubscribers",
                                    date("Y-m-d", strtotime('-24 months')) );

    $GraphData = array();
    foreach ($Data as $Item)
    {
        if ($Item["DataTwo"] > 0 )
            $GraphData[ strtotime( $Item["EventDate"] ) ] = array(
                $Item["DataTwo"] );
    }

    global $H_Graph;
    $H_Graph = new Graph(Graph::TYPE_DATE, $GraphData );

    $H_Graph->Title("");
    $H_Graph->XLabel("Date");
    $H_Graph->YLabel( $H_List." Subscribers" );
}
