<?php

require_once "lib/session.php";
require_once "lib/render.php";

define('about_error_template',
       '<div class="error">
An error occurred when processing your request:
<br />
%s
</div>');

define('about_body',
       '<p>
  This is a <a href="http://scout.wisc.edu/Projects/CWIS">CWIS</a>
 <a href="http://www.openid.net/">OpenID</a> server
  endpoint. It can be used to log in to other sites that support OpenID with your
  CWIS username and password.
</p>
<p>
  Your OpenId URL will be:
<pre>
http://test.scout.wisc.edu/~chalpin/CWIS/plugins/OpenIdServer/server.php/idpage?user=USERNAME
</pre>
');

/**
 * Render the about page, potentially with an error message
 */
function about_render($error=false, $internal=true)
{
    $headers = array();
    $body = sprintf(about_body, buildURL());
    if ($error) {
        $headers[] = $internal ? http_internal_error : http_bad_request;
        $body .= sprintf(about_error_template, htmlspecialchars($error));
    }
    $current_user = getLoggedInUser();
    return page_render($body, $current_user, 'OpenID Server Endpoint');
}

?>
