<?php
#
#   FILE:  SPT--MDHome.php
#
#   FUNCTIONS PROVIDED:
#       PrintTotalNumberOfResources()
#       PrintNumberOfReleasedResources()
#       PrintTotalNumberOfClassifications()
#       PrintTotalNumberOfControlledNames()
#           - print current values for each of the above
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

$NavDirCorrection = "../";
require_once($NavDirCorrection."include/SPT--Common.php");
require_once($NavDirCorrection."include/SPT--MetadataSchema.php");
require_once($NavDirCorrection."include/SPT--ResourceFactory.php");
require_once($NavDirCorrection."include/SPT--ClassificationFactory.php");
require_once($NavDirCorrection."include/SPT--ControlledNameFactory.php");
require_once($NavDirCorrection."include/SPT--SearchEngine.php");

PageTitle("Metadata Tool");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------
function PrintTotalNumberOfResources()
{
    # query total number of resources from DB
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetItemCount();

    # print result of query
    print(number_format($ResourceCount));
    //print($ResourceCount);
}

function PrintNumberOfReleasedResources()
{
    # query number of released resources from DB
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetItemCount("ReleaseFlag = 1");

    # print result of query
    print(number_format($ResourceCount));
}

function PrintNumberOfRatedResources()
{
    # query number of released resources from DB
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetRatedResourceCount();

    # print result of query
    print(number_format($ResourceCount));
}

function PrintTotalNumberOfClassifications()
{
    # query total number from DB
    $ClassFactory = new ClassificationFactory();
    $TotalCount = $ClassFactory->GetItemCount();

    # print result of query
    print(number_format($TotalCount));
}

function PrintTotalNumberOfControlledNames()
{

    $MSchema = new MetadataSchema();
    $CNFactory = new ControlledNameFactory();

    # get list of controlledname fields
    $Fields = $MSchema->GetFields(MDFTYPE_CONTROLLEDNAME);

    $TotalCount = 0;
    foreach ($Fields as $Field)
    {
        $TotalCount += $CNFactory->GetItemCount("FieldId = ".$Field->Id());
    }

    # print result of query
    print(number_format($TotalCount));
}

function PrintTotalSearchTerms()
{
    $SearchEngine = new SPTSearchEngine();
    $TotalCount = $SearchEngine->SearchTermCount();

    # print result of query
    print(number_format($TotalCount));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------
CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_CLASSADMIN, PRIV_NAMEADMIN, PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN);

include($NavDirCorrection."include/SPT--StandardHtmlPageLoad.php");


?>