<?PHP

#
#   FILE:  SPT--RebuildSearchDB.php
#
#   FUNCTIONS PROVIDED:
#       RebuildIsComplete()
#           - returns TRUE if rebuild is complete
#       PercentRebuildComplete()
#           - returns percentage of rebuild completed so far
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SearchEngine.php");
PageTitle("Rebuilding Search Database");

CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);


function ProcessResourceChunk($StartingResourceId)
{
    global $DB;

    # number of resources to update in each pass
    $RebuildChunkSize = 15;

    # if starting resource ID is set
    if (isset($StartingResourceId))
    {
        # process (update search data for) current chunk of resources
        $SearchEngine = new SPTSearchEngine;
        $EndResourceId = $SearchEngine->UpdateForItems(
                $StartingResourceId, $RebuildChunkSize);
    }
    else
    {
        # initialize starting resource ID
        $NewStartingResourceId = 0;
        $EndResourceId = -1;
    }

    # if we have processed all resources
    $RFactory = new ResourceFactory();
    $LastResourceId = $RFactory->GetHighestItemId();
    if ($EndResourceId >= $LastResourceId)
    {       
        # set flag to indicate we're done
        $NewStartingResourceId = -1;
    }
    else
    {
        # set new starting resource ID
        $NewStartingResourceId = $EndResourceId + 1;
    }

    # return new starting resource ID to caller
    return $NewStartingResourceId;
}

function SetAutoRefreshStatus($NewStartingResourceId)
{
    global $AutoRefreshToPage;
    global $SavePageGenerationBeginTime;

    if ($NewStartingResourceId != -1)
    {
        $Elapsed = isset($_GET["RSDElapsed"]) ? $_GET["RSDElapsed"] : 0;
        $ElapsedTime = intval($Elapsed
                + (getmicrotime() - $SavePageGenerationBeginTime));
        $AutoRefreshToPage = 
                "SPT--RebuildSearchDB.php"
                ."?RSDStartingResourceId=${NewStartingResourceId}"
                ."&RSDElapsed=${ElapsedTime}";
    }
}

function RebuildIsComplete()
{
    global $StartingResourceId;

    if ($StartingResourceId == -1) {  return TRUE;  } else {  return FALSE;  }
}

function PercentRebuildComplete()
{
    global $DB;
    global $StartingResourceId;

    # get total number of resources
    $RFactory = new ResourceFactory();
    $TotalResources = $RFactory->GetItemCount(); 

    # get number of resources left to process
    $ResourcesProcessed = $RFactory->GetItemCount(
                            "ResourceId<${StartingResourceId}");

    # calculate percentage complete and return to caller
    return sprintf("%.1f", ($ResourcesProcessed * 100) / $TotalResources);
}

function EstimatedTimeRemainingInSeconds()
{
    # calculate initial estimate
    if (isset($_GET["RSDElapsed"]))
    {
        $Elapsed = $_GET["RSDElapsed"];
    }
    else
    {
        $Elapsed = 0;
    }
    $EstimatedTotalTime = ($Elapsed * 100) / PercentRebuildComplete();

    # adjust for rebuild slowing toward end
    $EstimatedTotalTime = $EstimatedTotalTime * (1 + ((100 - PercentRebuildComplete()) / 300));

    # return result to caller
    return $EstimatedTotalTime - $Elapsed;
}

function EstimatedTimeRemaining()
{
    if (PercentRebuildComplete() < 2)
    {
        return "-:--";
    }
    else
    {
        return sprintf("%d:%02d:%02d", 
                intval(EstimatedTimeRemainingInSeconds() / 3600),
                intval((EstimatedTimeRemainingInSeconds() / 60) % 60),
                (EstimatedTimeRemainingInSeconds() % 60));
    }
}

function ElapsedTime()
{
    return sprintf("%d:%02d:%02d", 
            intval($_GET["RSDElapsed"] / 3600),
            intval(($_GET["RSDElapsed"] / 60) % 60),
            ($_GET["RSDElapsed"] % 60));
}

function TotalNumberOfResources()
{
    $RFactory = new ResourceFactory();
    return $RFactory->GetItemCount();
}

function EstimatedTimeOfCompletion()
{
    if (PercentRebuildComplete() < 2)
    {
        return "-:--";
    }
    else
    {
        if (EstimatedTimeRemainingInSeconds() > (12 * 60 * 60))
        {
            return date("D g:ia", getmicrotime() + EstimatedTimeRemainingInSeconds());
        }
        else
        {
            return date("g:ia", getmicrotime() + EstimatedTimeRemainingInSeconds());
        }
    }
}


# save page generation timestamp
$SavePageGenerationBeginTime = getmicrotime();
if (isset($_GET["RSDStartingResourceId"]))
{
    $StartingId = $_GET["RSDStartingResourceId"];
}
else
{
    $StartingId = NULL;
}
$StartingResourceId = ProcessResourceChunk($StartingId);
SetAutoRefreshStatus($StartingResourceId);

include(FindUIFile("include/SPT--StandardPageStart.html"));
# restore page generation timestamp so accurate time will be calculated
$PageGenerationBeginTime = $SavePageGenerationBeginTime;
include(CorrespondingHtmlFile());
include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>
