<?php
#
#   FILE:  SPT--SelectEditUserComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#    ://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# confirm remove user(s)
function ConfirmRemoveUsers()
{
    global $_POST, $Session;

    reset($_POST);
	#Remplazar: while (list($name, $value) = each($directives)) -> foreach($directives as $name => $value)
    #while (list($Var, $Value) = each ($_POST))
	foreach($_POST as $Var => $Value)
    {
        if (preg_match("userid_([0-9]+)", $Var, $Regs))
        {
            if (isset($Value))
            { 
                $UserRemoveArray[] = intval($Value);
            }
        }
    }
    $Session->PassVariable("UserRemoveArray", $UserRemoveArray);
    PrintAutoRefreshPage("Confirm Remove User", 
                                    "SPT--ConfirmRemoveUser.php");
    exit;
}

# remove user(s) 
function RemoveUsers()
{
    global $Session;

    $DB = new SPTDatabase();

    $UserRemoveArray = $Session->Get("UserRemoveArray");
    foreach ($UserRemoveArray as $UserId)
    {
        $RemoveUser = new User($DB, intval($UserId));
        $RemoveUser->Delete();
    }
    PrintAutoRefreshPage("Select User Account to Edit", 
                                "SPT--SelectEditUser.php");
    exit;
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN);

# grab entry information from database
$DB = new SPTDatabase();

$Submit = $_POST["Submit"];

# check for Cancel button from previous screen
if ($Submit == "Cancel")
{
    PrintAutoRefreshPage("Select User Account to Edit", 
                            "SPT--SelectEditUser.php");
    exit;
}
else if (substr($Submit, 0, 6) == "Remove")
{
    # OK to remove selected user?
    if ($Session->Get("OkayToRemove"))
    {
        RemoveUsers();
    }
    # build array list of users to remove
    else
    {
        ConfirmRemoveUsers();
    }
}

?>
