<?php
#
#   FILE:  SPT--FieldDefinition.php
#
#   FUNCTIONS PROVIDED:
#       PrintDefinition()
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ResourceFactory.php");

PageTitle("Field Definition");
# provide relative path to base SPT directory
$NavDirCorrection = "../";

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print the heading
function PrintDefinition()
{
    global $Session;

    $Schema = new MetadataSchema();
    $FieldId = $Session->Get("FieldId");
    $Field = $Schema->GetField($FieldId);

    print $Field->Description();
}

function PrintFieldName()
{
    global $Session;

    $Schema = new MetadataSchema();
    $FieldId = $Session->Get("FieldId");
    $Field = $Schema->GetField($FieldId);

    print $Field->Name();
}

function PrintReturnButton()
{
    $RFactory = new ResourceFactory();
    $ResourceId = $RFactory->GetCurrentEditedItemId();
    $Resource = new Resource($ResourceId);
    $IsTemp = $Resource->IsTempResource();
    $Label = $IsTemp ? "Add New Resource" : "Edit Resource";  
    print "Return to ".$Label;
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
