<?php
#
#   FILE:  SPT--SearchControlledName.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Qualifier.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ControlledNameFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintFControlledName()
{
	global $F_ControlledName;

	print isset($F_ControlledName) ? $F_ControlledName : "";
}

# more controlled names to display?
function PreviousNamesAvailable()
{
    global $Offset;

    return ($Offset >= 250) ? TRUE : FALSE;
}

# previous controlled names to display
function NextNamesAvailable()
{
    global $NumRows;
    
    return ($NumRows <= 250) ? FALSE : TRUE;
}

# print previous link
function PrintPrevLink()
{
    global $SysConfig;
    global $Offset;

    $NewOffset = $Offset - 250;
    print "SPT--SearchControlledName.php?Offset=$NewOffset";
}

# print next link
function PrintNextLink()
{
    global $SysConfig;
    global $Offset;

    $NewOffset = $Offset + 250;
    print "SPT--SearchControlledName.php?Offset=$NewOffset";
}

# function to print error message
function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

# function to print display string
function PrintDisplayString()
{
    global $DisplayString;

    print $DisplayString;
}

# function to return if Existing Resource Record or Not
function ExistingResource()
{
    global $ResourceId;

    return ($ResourceId > 0) ? true : false;
}

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print the ControlledName
function PrintControlledName()
{
    global $ControlledName;

    print stripslashes($ControlledName);
}

# returns true if field uses qualifiers
function  FieldUsesQualifiers()
{
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    return $Field->UsesQualifiers();
}

# returns true if field uses item level qualifiers
function FieldHasItemLevelQualifiers()
{
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    return $Field->HasItemLevelQualifiers();
}

# return default qualifier
function FieldDefaultQualifier()
{
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    return $Field->DefaultQualifier();
}

# function to print the Qualifier 
function PrintQualifierName()
{
    global $QualifierId;

    # only print if it exists
    if (FieldUsesQualifiers())
    {
        if (is_null($QualifierId))
            $QualifierId = FieldDefaultQualifier();
        $Qualifier = new Qualifier($QualifierId);
        if (is_object($Qualifier))
            print " (".stripslashes($Qualifier->Name()).")";
    }
}

# function to print list of qualifiers
function PrintQualifierOrList()
{
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);

    if (FieldHasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);
        PrintOptionList("F_Qualifier", $Items, NULL, 0, 1, NULL, false);
        
   }
    else
    {
        $QualifierId = FieldDefaultQualifier();
        PrintQualifierName();
    }
}

# function to print the ControlledNameId
function PrintControlledNameId()
{
    global $ControlledNameId;

    print $ControlledNameId;
}

# return if true if F_FieldId specified, else false
function FieldIdSet()
{
    global $F_FieldId;

    return ($F_FieldId != 0) ? true : false; 
}

# print F_FieldId 
function PrintFieldId()
{
    global $F_FieldId;

    print $F_FieldId;
}

# function to print out if ControlledNames found
function ControlledNamesExist()
{
    global $NumRows;

    return $NumRows;
}

# function to see if Form variable F_ControlledName is empty or not
function SearchEntered()
{
    global $F_ControlledName;

    return (empty($F_ControlledName)) ? false : true;
}

# display found controlled names
function DisplayFoundControlledNames()
{
    global $F_ControlledName;
    global $DB;
    global $DisplayString;
    global $TypeString;
    global $F_FieldId;
    global $ResourceId;
    global $Index;
    global $ControlledName;
    global $ControlledNameId;
    global $QualifierId;
    global $NumRows;
    global $Offset;

    if (empty($F_ControlledName))
    {
        $CNFactory = new ControlledNameFactory();
        $CNIds = $CNFactory->GetItemIds("FieldId = $F_FieldId ".
                "ORDER BY ControlledName LIMIT $Offset, 999999999");

        $Index=0;
        $NumRows = count($CNIds);
        if ($NumRows > 0)
        {
            DisplayHeading();
            $SavedOffset = $Offset;
            DisplayAddButtons();     
            StartRow();
            while ($Index < min(250,$NumRows))
            {
                $CN = new ControlledName($CNIds[$Index]);
                $ControlledName = $CN->Name();
                $ControlledNameId = $CN->Id();
                $QualifierId = $CN->QualifierId();
                DisplayControlledNameSelection();
                if ($Index && (($Index+1) % 3) == 0)
                {
                    EndRow();
                    StartRow();
                }
                $Index++;
            }
            # add end row if needed
            if ($Index % 3)
                EndRow();
            $Offset = $SavedOffset;
            DisplayAddButtons();           
            return;
        }
    }
    # search for a controlled name 
    else
    {
        # replace * and space with wild cards
        # pass +, squiqgles, and brackets through as literals
        # so that REGEXP in query doesn't puke
        $ControlledName = str_replace("*", ".*.", $F_ControlledName);
        $ControlledName = str_replace(" ", ".*.", $ControlledName);       
        $ControlledName = str_replace("{", "[{]", $ControlledName);       
        $ControlledName = str_replace("}", "[}]", $ControlledName);       
        $ControlledName = str_replace("(", "[(]", $ControlledName);       
        $ControlledName = str_replace(")", "[)]", $ControlledName); 
        $ControlledName = str_replace("+", "[+]", $ControlledName);
        $ControlledName = str_replace("'", "[']", $ControlledName); 
         
        # this query gets us close
        $Query = "Select ControlledName, C.ControlledNameId, ".
                "FieldId, QualifierId from ControlledNames AS C ".
                "LEFT JOIN VariantNames ".
                "AS V ON C.ControlledNameId=V.ControlledNameId WHERE (".
                "ControlledName REGEXP \"$ControlledName\" OR ".
                "VariantName REGEXP \"$ControlledName\") ".
                "AND FieldId = ".$F_FieldId." ".
                "ORDER BY ControlledName";

#       echo "query=$Query<br>";
    
        $DB->Query("$Query");
        $Index=0;
        $NumRows = $DB->NumRowsSelected();
        if ($NumRows > 0)
        {
            DisplayHeading();
            $SavedOffset = $Offset;
            StartRow();
            while ($Index < $DB->NumRowsSelected())
            {
                $Result = $DB->FetchNextRowArray();
                $ControlledName = $Result["ControlledName"];
                $ControlledNameId = $Result["ControlledNameId"];
                $QualifierId = $Result["QualifierId"];
                DisplayControlledNameSelection();
                if ($Index && (($Index+1) % 3) == 0)
                {
                    EndRow();
                    StartRow();
                }
                $Index++;
            }
            # add end row if needed
            if ($Index % 3)
                EndRow();
            $Offset = $SavedOffset;
            DisplayAddButtons();
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN);

$Schema = new MetadataSchema;

if (isset($_GET["Offset"]))
    $Offset = $_GET["Offset"];
else
    $Offset = 0;

if (isset($_GET["F_FieldId"]))
    $F_FieldId = $_GET["F_FieldId"];
else
    $F_FieldId = $Session->Get("F_FieldId");

if ( isset($_POST["F_ControlledName"]) )
    $F_ControlledName = $_POST["F_ControlledName"];

if ($F_FieldId)
{
    $Field = $Schema->GetField($F_FieldId);
    $DisplayString = $Field->Name();
}
else
    $DisplayString = "Controlled Name";

PageTitle("Assign/Add ".$DisplayString."s");

$RFactory = new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();
$Session->PassVariable("F_FieldId", $F_FieldId);

# handle Cancel button
if ( isset($_POST["Submit"]) && $_POST["Submit"] == "Cancel" )
{
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}
    
$NavDirCorrection = "../";

include("include/SPT--StandardHtmlPageLoad.php");

?>
