<?php
#
#   FILE:  SPT--UpdateControlledNameList.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ControlledName.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# remove list value
function DeleteListValue()
{
    global $DB, $Session, $FieldName;

    $CNArray = array();

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (ereg("cnid_([0-9]+)", $Var, $Regs))
        {
            if (!empty($Value))
            { 
                $CNArray[] = $Value;
            }
        }
    }

    # confirm removal of options if any selected
    if (count($CNArray) > 0)
    {
        $Session->PassVariable("CNArray", $CNArray);
        $Session->PassVariable("FieldName", $FieldName);
        PrintAutoRefreshPage("Confirm Delete Options", 
            "SPT--ConfirmDeleteControlledName.php?action=Options".
            "&target=SPT--UpdateControlledNameList.php");
        exit;
    }
}

# confirm deletion of option values
function ConfirmDeleteOptions()
{
    global $Session;

    $CNArray = $Session->Get("CNArray");
    foreach ($CNArray as $CNId)
    {
        $CN = new ControlledName($CNId);
        $CN->Delete(TRUE);
    }
}

# add list value
function AddListValue()
{
    global $DB, $ErrorMessages, $Session, $F_NewValue, $F_NewQualifierId;
    global $FieldId;

    # escape quotes
    $F_NewValue = addslashes($F_NewValue);

    # force "--" selection to NULL
    if (is_null($F_NewQualifierId) || $F_NewQualifierId == "--")
        $F_NewQualifierId = "NULL";
    
    # first check to see if it already exists
    if (!empty($F_NewValue))
    {
        $CN = new ControlledName(NULL, $F_NewValue, $FieldId,
                $F_NewQualifierId);

        # exists, report error
        if ($CN->Status() == CNSTAT_EXISTS)
        {
            $ErrorMessages[] = "<b>Error: </b>".$F_NewValue." already exists";
            return;
        }
        # otherwise, it has been added 
    }
    else
        $ErrorMessages[] = "<b>Error: </b>No Value Entered";
}

# update list value
function UpdateListValue()
{
    global $DB;
    global $FieldId;

    $Schema = new MetadataSchema();
    $Field = $Schema->GetField($FieldId);

    # initialize QualifierId to NULL
    $QualifierId = "NULL";

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (ereg("cnid_([0-9]+)", $Var, $Regs))
        {
            if (isset($Value))
                $ControlledNameId = $Value;
            continue;
        }
        if (ereg("cn_([0-9]+)", $Var, $Regs))
        {
            $Value = trim($Value);
            $ControlledName = addslashes($Value);
            if ($Field->HasItemLevelQualifiers())
                continue;
        }
        if (ereg("qid_([0-9]+)", $Var, $Regs))
        {
            $QualifierId = $Value;
            if ($QualifierId == "--")
                $QualifierId = "NULL";
        }

        # do the update 
        if (!empty($ControlledName) && isset($ControlledNameId))
        { 
            $CN = new ControlledName($ControlledNameId);
            $CN->Name($ControlledName);
            $CN->FieldId($FieldId);
            $CN->QualifierId($QualifierId);
            $ControlledNameId = NULL;
        }
    }
}

# remove default option value for advanced search
function RemoveDefault()
{
    global $FieldId;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the field that matches this type
    $Field = $Schema->GetField($FieldId);
    if (is_object($Field))
        $Field->DefaultValue(NULL);
}

# set default option value for advanced search
function SetDefault()
{
    global $FieldId;

    reset($_POST);
    while (list($var, $value) = each ($_POST))
    {
        if (ereg("cnid_([0-9]+)",$var,$regs))
        {
            if ($value != "")
            { 
                # Get the schema
                $Schema = new MetadataSchema();

                # Get the fields for the schema
                $Field = $Schema->GetField($FieldId);
                $Field->DefaultValue($value);
                break;
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_NAMEADMIN);

# grab entry information from database
$DB = new SPTDatabase();

if (isset($_POST["F_NewValue"]))
    $F_NewValue = $_POST["F_NewValue"];
if (isset($_POST["qid_"]))
    $F_NewQualifierId = $_POST["qid_"];
$Submit = $_POST["Submit"];

$FieldId = $Session->Get("FieldId");
$FieldName = $Session->Get("FieldName");

$ErrorMessages = array();

# check for Cancel button from previous screen
if ($Submit == "Cancel")
{
    # if CNArray is set, then coming from confirm delete options
    # else, canceling from Edit Option Lists
    $CNArray = $Session->Get("CNArray");
    if (is_null($CNArray))
    {
        PrintAutoRefreshPage("SPT Metadata Tool", "SPT--MDHome.php");
        exit;
    }
}
else if (substr($Submit, 0, 15) == "Delete Selected")
{
    DeleteListValue();
}
else if ($Submit == "Confirm Delete Options")
{
    ConfirmDeleteOptions();
}
else if (substr($Submit, 0, 15) == "Update Selected")
{
    UpdateListValue();
}
else if (substr($Submit, 0, 3) == "Add" ||
    (empty($Submit) && isset($F_NewValue)))
{
    AddListValue();
}
else if (substr($Submit, 0, 3) == "Set")
{
    SetDefault();
}
else if (substr($Submit, 0, 14) == "Remove Default")
{
    RemoveDefault();
}
else if (isset($Submit))
{
    $FieldName = $Submit;
}

$Session->PassVariable("FieldName", $FieldName);
$Session->PassVariable("ErrorMessages");
PrintAutoRefreshPage("Edit Option Lists", "SPT--EditControlledNameList.php");

?>
