<?PHP

#
#   FILE:  SPT--PrivilegeFactory.php
#
#   METHODS PROVIDED:
#       PrivilegeFactory()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Collection Workflow Integration System
#   Copyright 2007 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--Common.php");
require_once(dirname(__FILE__)."/SPT--ItemFactory.php");
require_once(dirname(__FILE__)."/SPT--Privilege.php");


class PrivilegeFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function __construct()
    {
        #$this->ItemFactory("Privilege", "CustomPrivileges", "Id", "Name");
		parent::__construct("Privilege", "CustomPrivileges", "Id", "Name");
    }

    # get all privileges
    # (returns array of privilege objects/strings with IDs for index)
    function GetPrivileges($IncludePredefined = TRUE, $ReturnObjects = TRUE)
    {
        # read custom privileges in from DB
        $PrivNames = $this->GetItemNames();

        # add in predefined privileges if requested
        if ($IncludePredefined)
        {
            global $G_PrivDescriptions;
            $PrivNames = $G_PrivDescriptions + $PrivNames;
        }

        # if caller requested objects to be returned
        if ($ReturnObjects)
        {
            # convert strings to objects and return to caller
            foreach ($PrivNames as $Id => $Name)
            {
                $PrivObjects[$Id] = new Privilege($Id);
            }
            return $PrivObjects;
        }
        else
        {
            # return strings to caller
            return $PrivNames;
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
