<?PHP

#
#   FILE:  SPT--SPTEventLog.php
#
#   METHODS PROVIDED:
#       SPTEventLog()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Scout Portal Toolkit
#   Copyright 2007 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("Scout--EventLog.php");
if (InMetadataTool()){
require_once("../include/SPT--SPTDatabase.php");
} else {
	require_once("include/SPT--SPTDatabase.php");
}

# define event types
define("SPTEVENT_USERLOGIN", 1);
define("SPTEVENT_NEWACCOUNTSIGNUP", 2);
define("SPTEVENT_NEWACCOUNTCONFIRM", 3);
define("SPTEVENT_SEARCH", 4);
define("SPTEVENT_ADVANCEDSEARCH", 5);
define("SPTEVENT_RESOURCELINKCLICK", 6);
define("SPTEVENT_OAIHARVEST", 7);

# define user types
define("SPTUSERTYPE_ALL", 1);
define("SPTUSERTYPE_ANONYMOUS", 2);
define("SPTUSERTYPE_NONPRIVILEGED", 3);
define("SPTUSERTYPE_PRIVILEGED", 4);

class SPTEventLog extends EventLog {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function __construct()
    {
        # create database for use by our parent
        $DB = new SPTDatabase();

        # invoke parent constructor
        global $G_User;
        #$UserId = $G_User->IsLoggedIn() ? $G_User->Id() : -1;
		$UserId = -1;
        #$this->EventLog($DB, $UserId);
		parent::__construct($DB, $UserId);
    }

    # limit events to specific user type
    function LimitFindToUserType($UserType)
    {
        # set search conditions based on user type
        switch ($UserType)
        {
            case SPTUSERTYPE_NONPRIVILEGED:
                $this->ExcludeUsersWithPrivileges("<", PRIV_POSTTOFORUMS);
                $this->ExcludeUsersWithPrivileges(">", PRIV_USERDISABLED);
                break;

            case SPTUSERTYPE_PRIVILEGED:
                break;
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
