<?PHP
#
#   FILE:  SPT--FileName.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELD ("PUT") PARAMETERS EXPECTED:
#       F_ReleaseFlag
#           - ?
#       F_AddedBy
#           - ?
#       F_LastModifiedBy
#           - ?
#       F_MaxRecords
#           - ?
#       F_SearchCat[N]
#           - IDs (?) indicating which metadata field F_SearchText parameters apply to
#       F_SearchText[N]
#           - text to search for
#       Submit
#           - ?
#
#   URL ("GET") PARAMETERS EXPECTED:
#       Q
#           - if set to "Y" indicates that GET parameters should be used to specify search
#       F<field ID>
#           - contains the search text for the field specified by <field ID> (e.g. F2=text)
#       G<field ID>
#           - contains a dash-separated list of controlled name IDs for the option field
#               specified by <field ID> (e.g. G23=4-12-87)
#       SR
#           - starting index of range of search results to display (first result is at index 0)
#       RP
#           - number of results per page
#
#   Part of the Scout Portal Toolkit
#   Copyright 2005 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("Axis--UserFactory.php");
require_once("include/SPT--Common.php");
require_once("include/SPT--SearchEngine.php");
require_once("include/SPT--GlobalSearchEngine.php");
require_once("include/SPT--SavedSearch.php");
require_once("include/SPT--SPTEventLog.php");
PageTitle("Search Results");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# return AllResourcesFlagged flag
function AllResourcesFlagged()
{
    global $AllResourcesFlagged;
    return $AllResourcesFlagged;
}

# get count of flagged files
function GetFlaggedFilesCount()
{
    global $NavDirCorrection;
    
    $ScriptFileName = GetFullScriptFileName();

    $InputPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/".$NavDirCorrection."TempStorage/InputData";

    $ResourceCount = 0;

    if (is_readable($InputPath))
    {
        $fpi = fopen($InputPath, "r");
        while (!feof($fpi))
        {
            $ResourceId = fgets($fpi, 4096);
            $ResourceId = trim($ResourceId);

            if (empty($ResourceId))
                break;
        
            $ResourceCount++;
        }
    }
    return $ResourceCount;
}

# print resource entry found as a result of an advanced search 
function PrintSearchResults()
{
    global $User;
    global $G_SearchResults;
    global $G_Engine;

    # if this is a global search
    if (IsGlobalSearch())
    {
        # for each search result
        foreach ($G_SearchResults as $SearchResult)
        {
            PrintGlobalSearchResult($SearchResult);
        }
    }
    else
    {
        # for each search result
        foreach ($G_SearchResults as $ResourceId => $Score)
        {
            $Resource = new Resource($ResourceId);
    
			if (strpos($_SERVER['REQUEST_URI'],"SPT--AdvancedSearch.php") > 0)
			{ #consevamos el acceso desde tropped courses normal
				PrintSearchResult($Resource,
					"SPT--FullRecord.php?ResourceId=${ResourceId}",
					CheckEditResource( $Resource ),
					"MetadataTool/SPT--DBEntry.php?ResourceId=${ResourceId}",
					$Resource->ScaledCumulativeRating(), NULL, TRUE, TRUE, 
					$User->HasPriv(PRIV_SYSADMIN), $G_Engine->SearchTerms()); 
			}
			else
			{
				PrintSearchResult($Resource,
					$GLOBALS['theses_prefix']."full-record-resource?ResourceId=${ResourceId}",
					CheckEditResource( $Resource ),
					"MetadataTool/SPT--DBEntry.php?ResourceId=${ResourceId}",
					$Resource->ScaledCumulativeRating(), NULL, TRUE, TRUE, 
					$User->HasPriv(PRIV_SYSADMIN), $G_Engine->SearchTerms()); 
			}
        }
    }
}

function PrintSearchString()
{
    global $G_SearchCriteria;

    print(stripslashes($G_SearchCriteria));
}

function PrintTotalNumberOfResults()
{
    global $G_Engine;

    print($G_Engine->NumberOfResults());
}

function PrintStartingResultNumber()
{
    global $G_StartingResult;
    global $G_Engine;

    if ($G_Engine->NumberOfResults() == 0)
    {
        print("0");
    }
    else
    {
        print($G_StartingResult + 1);
    }
}

function PrintEndingResultNumber()
{
    global $G_StartingResult;
    global $G_RecordsPerPage;
    global $G_Engine;

    print(min(($G_StartingResult + $G_RecordsPerPage), $G_Engine->NumberOfResults()));
}

function PreviousResultsAvailable()
{
    global $G_StartingResult;

    return ($G_StartingResult > 0) ? TRUE : FALSE;
}

function NextResultsAvailable()
{
    global $G_StartingResult;
    global $G_RecordsPerPage;
    global $G_Engine;

    return (($G_StartingResult + $G_RecordsPerPage) < $G_Engine->NumberOfResults()) ? TRUE : FALSE;
}

function PrintPreviousResultsLink()
{
    global $G_StartingResult;
    global $G_RecordsPerPage;
    global $Editing;
    global $G_SearchGroupsForUrl;

    $NewStartingResult = max(($G_StartingResult - $G_RecordsPerPage), 0);
	if (strpos($_SERVER['REQUEST_URI'],"SPT--AdvancedSearch.php") > 0)
	{
		print("SPT--AdvancedSearch.php?Q=Y&".$G_SearchGroupsForUrl."&RP=".$G_RecordsPerPage.
			"&SR=". $NewStartingResult.(IsGlobalSearch() ? "&GS=Y" : ""));
	}
    else
	{
		$_GET['SR'] = $NewStartingResult.(IsGlobalSearch() ? "&GS=Y" : "");
		print("?Q=Y&".$G_SearchGroupsForUrl."&RP=".$G_RecordsPerPage.
			"&SR=". $NewStartingResult.(IsGlobalSearch() ? "&GS=Y" : ""));
	}
}

function PrintNextResultsLink()
{
    global $G_StartingResult;
    global $G_RecordsPerPage;
    global $Editing;
    global $G_SearchGroupsForUrl;

    $NewStartingResult = $G_StartingResult + $G_RecordsPerPage;
	if (strpos($_SERVER['REQUEST_URI'],"SPT--AdvancedSearch.php") > 0)
	{
		print("SPT--AdvancedSearch.php?Q=Y&".$G_SearchGroupsForUrl."&RP=".$G_RecordsPerPage.
			"&SR=". $NewStartingResult.(IsGlobalSearch() ? "&GS=Y" : ""));
	}
    else
	{
		$_GET['SR'] = $NewStartingResult.(IsGlobalSearch() ? "&GS=Y" : "");
		print("?Q=Y&".$G_SearchGroupsForUrl."&RP=".$G_RecordsPerPage.
			"&SR=". $NewStartingResult.(IsGlobalSearch() ? "&GS=Y" : ""));
	}
}

function NoResultsFound()
{
    global $G_Engine;

    return ($G_Engine->NumberOfResults() == 0) ? TRUE : FALSE;
}

function PrintSearchTime()
{
    global $G_Engine;

    printf("%.3f", $G_Engine->SearchTime());
}

function PrintNumberOfPreviousResults()
{
    global $G_RecordsPerPage;

    print($G_RecordsPerPage);
}

function PrintNumberOfNextResults()
{
    global $G_RecordsPerPage;
    global $G_StartingResult;
    global $G_Engine;

    print(min($G_RecordsPerPage, ($G_Engine->NumberOfResults() - ($G_StartingResult + $G_RecordsPerPage))));
}

# return TRUE/FALSE indicating whether global search is available
function GlobalSearchIsAvailable()
{
return FALSE;
}

# return TRUE/FALSE indicating whether a global search was performed
function IsGlobalSearch()
{
    global $G_DoingGlobalSearch;
    return $G_DoingGlobalSearch;
}

# print URL for running global search
function PrintGlobalSearchLink()
{
    global $G_SearchGroupsForUrl;
    global $G_RecordsPerPage;

    print("SPT--AdvancedSearch.php?Q=Y&".$G_SearchGroupsForUrl."&RP=".$G_RecordsPerPage.
        "&SR=0&GS=Y");
}

# print URL for running local search
function PrintLocalSearchLink()
{
    global $G_SearchGroupsForUrl;
    global $G_RecordsPerPage;

    print("SPT--AdvancedSearch.php?Q=Y&".$G_SearchGroupsForUrl."&RP=".$G_RecordsPerPage.
        "&SR=0");
}

function PrintExportHiddenVars()
{
    global $G_SearchGroupsForUrl;
    global $G_RecordsPerPage;
    global $G_StartingResult;
    global $G_ExportFlagMsg;
    ?>
    <input type="hidden" name="F_ExportRequest" value="Y">
    <input type="hidden" name="F_SearchGroupsForUrl" value="<?PHP  print($G_SearchGroupsForUrl);  ?>">
    <input type="hidden" name="F_RecordsPerPage" value="<?PHP  print($G_RecordsPerPage);  ?>">
    <input type="hidden" name="F_StartingResult" value="<?PHP  print($G_StartingResult);  ?>">
    <?PHP
}

function PrintExportMessage()
{
    global $G_ExportFlagMsg;
    if (isset($G_ExportFlagMsg))
    {
        print("<p><b>".$G_ExportFlagMsg."</b></p>\n");
    }
    elseif (isset($_GET["EFM"]))
    {
        print("<p><b>".$_GET["EFM"]."</b></p>\n");
    }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# retrieve search criteria from search form values
function RetrieveSearchCriteriaFromFormValues()
{
    global $DB;

    # start with empty list of criteria
    $Criteria = array();
    
    # if this was actually just a keyword ("quick") search
    if (isset($_POST["F_SearchString"]))
    {
        # if there was a search string supplied
        if (strlen(trim($_POST["F_SearchString"])))
        {
            # add keyword string to search criteria
            $Criteria["MAIN"]["SearchStrings"]["XXXKeywordXXX"] = 
                    $_POST["F_SearchString"];
        }
    }
    else
    {
        # while there are search text fields left to examine
        $FieldIndex = 0;
        $Schema = new MetadataSchema();
        while (isset($_POST["F_SearchCat".$FieldIndex]))
        {
            # if value is available for box
            if (isset($_POST["F_SearchText".$FieldIndex])
                    && (strlen($_POST["F_SearchText".$FieldIndex])
                        || is_array($_POST["F_SearchText".$FieldIndex])))
            {
                # retrieve metadata field info for box
                if ($_POST["F_SearchCat".$FieldIndex] == "Keyword")
                {
                    $FieldName = "XXXKeywordXXX";
                }
                else
                {
                    $Field = $Schema->GetField($_POST["F_SearchCat".$FieldIndex]);
                    $FieldName = $Field->Name();
                }
    
                # if value represents multiple values
                $Value = $_POST["F_SearchText".$FieldIndex];
                if (is_array($Value))
                {
                    # for each value
                    foreach ($Value as $SingleValue)
                    {
                        # add value to search criteria
                        $Criteria[$Field->Id()]["SearchStrings"][$FieldName][] = "=".$Field->GetValueForId($SingleValue);
                    }
                }
                else
                {
                    # add value to search criteria
					if (isset($Criteria["MAIN"]["SearchStrings"][$FieldName]))
					{
	                    $Criteria["MAIN"]["SearchStrings"][$FieldName] .= " ".$Value;						
					}
					else
					{
	                    $Criteria["MAIN"]["SearchStrings"][$FieldName] = $Value;												
					}
                }
            }
    
            # move to next search box
            $FieldIndex++;
        }
    
        # for each possible limit field
        $Fields = $Schema->GetFields(MDFTYPE_OPTION | MDFTYPE_USER | MDFTYPE_FLAG | MDFTYPE_NUMBER);
        foreach ($Fields as $FieldId => $Field)
        {
            # if value is available for this field
            if (isset($_POST["F_SearchLimit".$FieldId])
                    && is_array($_POST["F_SearchLimit".$FieldId]))
            {
                # if flag field
                if ($Field->Type() == MDFTYPE_FLAG)
                {
                    # add flag value to search criteria (if meaningful)
                    if ($_POST["F_SearchLimit".$FieldId][0] >= 0)
                    {
                        $Criteria[$Field->Id()]["SearchStrings"][$Field->Name()][] = 
                                "=".$_POST["F_SearchLimit".$FieldId][0];
                    }
                }
                # else if numeric field
                elseif ($Field->Type() == MDFTYPE_NUMBER)
                {
                    # add flag value to search criteria (if meaningful)
                    if ($_POST["F_SearchLimit".$FieldId][0] >= 0)
                    {
                        $Criteria[$Field->Id()]["SearchStrings"][$Field->Name()][] = 
                                ">=".$_POST["F_SearchLimit".$FieldId][0];
                    }
                }
                # else if user field
                elseif ($Field->Type() == MDFTYPE_USER)
                {
                    # add user value to search criteria (if meaningful)
                    if ($_POST["F_SearchLimit".$FieldId][0] >= 0)
                    {
                        if (!isset($PrivilegedUsers)) 
                        {    
                            $UserFactory = new UserFactory($DB);
                            $PrivilegedUsers = $UserFactory->GetUsersWithPrivileges(
                                        PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN);
                        }
    
                        $UserId = $_POST["F_SearchLimit".$FieldId][0];
                        $Criteria[$Field->Id()]["SearchStrings"][$Field->Name()][] = "=".$PrivilegedUsers[$UserId];
                    }
                }
                # else
                else
                {
                    # retrieve possible values for field
                    $PossibleValues = $Field->GetPossibleValues();
    
                    # for each value
                    $Values = $_POST["F_SearchLimit".$FieldId];
                    foreach ($Values as $Value)
                    {
                        # if value is meaningful
                        if (isset($PossibleValues[$Value]))
                        {
                            # add value to search criteria
                            $Criteria[$Field->Id()]["SearchStrings"][$Field->Name()][] = "=".$PossibleValues[$Value];
                        }
                    }
                }
            }
        }
    }

    # set search logic
    foreach ($Criteria as $GroupIndex => $Group)
    {
        $Criteria[$GroupIndex]["Logic"] = ($GroupIndex == "MAIN") ? SEARCHLOGIC_AND : SEARCHLOGIC_OR;
    }

    # return search criterial to caller
    return $Criteria;
}


# handle user request to flag resources for export
function HandleExportFlaggingRequest($SubmitButtonText)
{
    global $G_SearchGroups;
    global $G_StartingResult;
    global $G_RecordsPerPage;
    global $G_ExportFlagMsg;
    global $NavDirCorrection;
    global $SysConfig;
	global $G_SearchResults;

    # get name of file used to hold IDs of resources to be exported
    $ExportFlagFileName = dirname($_SERVER["SCRIPT_FILENAME"])."/"
            .$NavDirCorrection."TempStorage/InputData";

    # if user requested to clear flagged resources
    if ($SubmitButtonText == "Clear Flagged List")
    {
        # clear flagged resource file (if any)
        if (file_exists($ExportFlagFileName)) {  unlink($ExportFlagFileName);  }

        # set message indicating flagged resource list cleared
        $G_ExportFlagMsg = "List of resources flagged for export has been cleared.";
    }
    # else if user requested to flag search results
    elseif (($SubmitButtonText == "Flag Selected for Export")
            || ($SubmitButtonText == "Flag All for Export"))
    {
        # set up search engine
        $Engine = new SPTSearchEngine();
        $Engine->SearchTermsRequiredByDefault($SysConfig->SearchTermsRequired());
        if (function_exists("FilterSearchResults"))
        {  
            $Engine->AddResultFilterFunction("FilterSearchResults");
        }

        # if user requested to flag all search results
        if ($SubmitButtonText == "Flag Selected for Export")
        {
            # run search and retrieve results for current page
            $G_SearchResults = $Engine->GroupedSearch(
                    $G_SearchGroups, $G_StartingResult, $G_RecordsPerPage);

            # for each search result
            $SelectedSearchResults = array();
            foreach ($G_SearchResults as $ResultId => $ResultScore)
            {
                # if result was selected for export
                if (isset($_POST["F_OkayForExport_".$ResultId]))
                {
                    # add to list of selected results
                    $SelectedSearchResults[$ResultId] = $ResultScore;
                }
            }
            $G_SearchResults = $SelectedSearchResults;
        }
        else
        {
            # run search and retrieve all results
            $G_SearchResults = $Engine->GroupedSearch($G_SearchGroups, 0, 999999);
        }

        # if no results were found to flag
        if (count($G_SearchResults) == 0)
        {
            # set message indicating no results found
            $G_ExportFlagMsg = "No resources found to be flagged for export.";
        }
        else
        {
            # read in list of previously selected resources (if any)
            $PreviouslySelectedResources = array();
            if (file_exists($ExportFlagFileName))
            {
                $FileText = file($ExportFlagFileName);
                if ($FileText)
                {  
                    foreach ($FileText as $Line) 
                    {  
                        $PreviouslySelectedResources[] = rtrim($Line);  
                    }
                }
            }

            # add list of newly selected resources to previously selected resources
            $NewlySelectedResources = array_keys($G_SearchResults);
            $UpdatedSelectedResources = array_merge(
                    $PreviouslySelectedResources, $NewlySelectedResources);
            $UpdatedSelectedResources = array_unique($UpdatedSelectedResources);

            # if list of selected resources has changed
            if ($UpdatedSelectedResources != $PreviouslySelectedResources)
            {
                # write out new list of selected resources
                $OutFileHndl = fopen($ExportFlagFileName, "w");
                foreach ($UpdatedSelectedResources as $ResourceId)
                {
                    fwrite($OutFileHndl, $ResourceId."\n");
                }
                fclose($OutFileHndl);
            }

            # set message indicating how many results flagged
            $NewlyFlaggedCount = count($UpdatedSelectedResources) - count($PreviouslySelectedResources);
            $G_ExportFlagMsg = $NewlyFlaggedCount." new resources flagged for export.";
        }
    }
}

# (automatically called in StandardPageStart if defined)
function AddJavascript()
{
    global $G_SearchGroupsForUrl;
    global $G_RecordsPerPage;
    global $G_StartingResult;
    global $G_SearchId;
    global $G_ExportFlagMsg;

    # add JavaScript to reset our URL to include search string (if needed)
    if (!strpos($_SERVER["REQUEST_URI"], "Q=Y"))
    {
        $UrlParameters = "Q=Y&".$G_SearchGroupsForUrl."&RP=".$G_RecordsPerPage."&SR=".$G_StartingResult;
        if (isset($G_ExportFlagMsg))
        {
            $UrlParameters .= "&EFM=".urlencode($G_ExportFlagMsg);
        }
        ?>
        <script><!--
            document.location.href = document.location + '?<?PHP  print($UrlParameters);  ?>';
        --></script>
        <?PHP
    }
}


# ----- MAIN -----------------------------------------------------------------

global $G_RecordsPerPage;
global $G_StartingResult;
global $G_SearchGroupsForUrl;

# if search parameters are specified as part of URL
if (isset($_GET["Q"]) && ($_GET["Q"] == "Y"))
{
    # retrieve search parameters from URL
    $G_SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($_GET);

    # retrieve search environment from URL
    $G_StartingResult = isset($_GET["SR"]) ? $_GET["SR"] : 0;
    $G_RecordsPerPage = isset($_GET["RP"]) ? $_GET["RP"] 
            : ($User->IsLoggedIn() ? $User->Get("RecordsPerPage") : 10);
}
# else if search parameters passed as part of "export flagging" form
elseif (isset($_POST["F_ExportRequest"])
        && ($_POST["F_ExportRequest"] == "Y")
        && isset($_POST["Submit"])
        && strlen($_POST["Submit"]))
{
    # retrieve search parameters and environment from export form hidden tags
    $G_StartingResult = $_POST["F_StartingResult"];
    $G_RecordsPerPage = $_POST["F_RecordsPerPage"];
    $G_SearchGroupsForUrl = $_POST["F_SearchGroupsForUrl"];
    $G_SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($G_SearchGroupsForUrl);
}
else
{
    # retrieve search parameters from form fields
    $G_SearchGroups = RetrieveSearchCriteriaFromFormValues();

    # retrieve search environment from form fields
    $G_RecordsPerPage = isset($_POST["F_RecordsPerPage"]) 
            ? $_POST["F_RecordsPerPage"] 
            : ($User->IsLoggedIn() ? $User->Get("RecordsPerPage") : 10);
    $G_StartingResult = 0;

    # save search type for logging
    $NewSearchType = isset($_POST["F_SearchString"]) ? "Quick" : "Advanced";
}

# build GET parameter string containing search parameters for use in URLs
$G_SearchGroupsForUrl = SavedSearch::TranslateSearchGroupsToUrlParameters($G_SearchGroups);

# handle export flagging operation if requested
if (isset($_POST["F_ExportRequest"])
        && ($_POST["F_ExportRequest"] == "Y")
        && isset($_POST["Submit"])
        && strlen($_POST["Submit"]))
{
    HandleExportFlaggingRequest($_POST["Submit"]);
}

# Redirect to home page if spambot field not filled correctly
if ((isset($_POST["F_Spmbt"]) && isset($_POST["F_JscptSpmbt"])) && 
     ($_POST["F_Spmbt"] !== "" || ($_POST["F_JscptSpmbt"] !== "" && $_POST["F_JscptSpmbt"] !== "8304RPC")))
{
    PrintAutoRefreshPage("Home", "SPT--Home.php");
    exit;
}

# if save search requested (coming from Advanced Search page)
if (isset($_POST["Submit"]) && ($_POST["Submit"] == "Save"))
{
    # if no search parameters were given
    if (!count($G_SearchGroups))
    {
        # set error message and return to Advanced Search page
        $ErrorMessages[] = "ERROR: No search parameters were specified.";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        PrintAutoRefreshPage("Error Found", "SPT--Advanced.php?".$G_SearchGroupsForUrl);
    }
    # else if user is logged in
    elseif ($User->IsLoggedIn())
    {
        # if we have a search ID available
        if (isset($_POST["F_SearchId"]))
        {
            # if we have what looks like a valid search name available
            $G_SearchId = $_POST["F_SearchId"];
            if (strlen(trim($_POST["F_SearchName"])))
            {
                # save search
                $SearchName = $_POST["F_SearchName"];
                $Search = new SavedSearch($G_SearchId, $SearchName, NULL, NULL, $G_SearchGroups);
    
                # jump to search management page
                PrintAutoRefreshPage("Manage Saved Searches", "SPT--SavedSearch.php");
            }
            else
            {
                # set error message and return to Advanced Search page
                $ErrorMessages[] = "ERROR: You must supply a name for the search to be saved.";
                $Session->PassVariable("ErrorMessages", $ErrorMessages);
                PrintAutoRefreshPage("Error Found", "SPT--Advanced.php?SI=".$G_SearchId."&".$G_SearchGroupsForUrl);
            }
        }
        else
        {
            # jump to search name input page
            PrintAutoRefreshPage("New Saved Search", "SPT--NewSavedSearch.php?".$G_SearchGroupsForUrl);
        }
    }
    else
    {
        # set error message and return to Advanced Search page
        $ErrorMessages[] = "ERROR: You must log in before saving searches.";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        PrintAutoRefreshPage("Error Found", "SPT--Advanced.php?".$G_SearchGroupsForUrl);
    }
}
# else if saved search editing cancelled (coming from Advanced Search page)
elseif (isset($_POST["Submit"]) && ($_POST["Submit"] == "Cancel"))
{
    # jump to search management page
    PrintAutoRefreshPage("Manage Saved Searches", "SPT--SavedSearch.php");
}
# else if search parameters were not part of URL
elseif (!isset($_GET["Q"]) || ($_GET["Q"] != "Y"))
{
    # reload page with search parameters as part of URL
    $UrlParameters = "Q=Y&".$G_SearchGroupsForUrl
            ."&RP=".$G_RecordsPerPage."&SR=".$G_StartingResult;
    if (isset($G_ExportFlagMsg))
    {
        $UrlParameters .= "&EFM=".urlencode($G_ExportFlagMsg);
    }
    else
    {
        $UrlParameters .= "&ST=".$NewSearchType;
    }
    PrintAutoRefreshPage("Performing Search", "SPT--AdvancedSearch.php?".$UrlParameters);
}
# else perform search
else
{
	global $G_Engine;
	global $G_SearchResults;
	
    # build search criteria string to display to user
    $G_SearchCriteria = SavedSearch::GetSearchGroupsAsTextDescription($G_SearchGroups);

    # if global search requested
    if (isset($_GET["GS"]) && ($_GET["GS"] == "Y"))
    {
        # set flag to indicate we are doing a global search
        $G_DoingGlobalSearch = TRUE;

        # set up global search engine
        $G_Engine = new GlobalSearchEngine();

        # perform search
        $G_SearchResults = $G_Engine->Search(
                $G_SearchGroups["MAIN"]["SearchStrings"]["XXXKeywordXXX"], 
                $G_StartingResult, $G_RecordsPerPage);
    }
    else
    {
        # set up search engine
        $G_Engine = new SPTSearchEngine();
        $G_Engine->SearchTermsRequiredByDefault($SysConfig->SearchTermsRequired());
        function FilterOutTempResources($Id) {  return ($Id < 0);  }
        $G_Engine->AddResultFilterFunction("FilterOutTempResources");
        if (function_exists("FilterSearchResults"))
        {  
            $G_Engine->AddResultFilterFunction("FilterSearchResults");
        }

        # if user does not have release or resource admin privileges
        if (!$User->HasPriv(PRIV_RELEASEADMIN, PRIV_RESOURCEADMIN))
        {
            # if there is a release flag field
            $Schema = new MetadataSchema();
            $ReleaseField = $Schema->GetFieldByName("Release Flag");
            if ($ReleaseField)
            {
                # add condition to show only released resources
                $G_SearchGroups[$ReleaseField->Id()]["SearchStrings"]
                        ["Release Flag"] = "=1";
                $G_SearchGroups[$ReleaseField->Id()]["Logic"] = SEARCHLOGIC_AND;
            }
        }

        # perform search
        $G_SearchResults = $G_Engine->GroupedSearch(
                $G_SearchGroups, $G_StartingResult, $G_RecordsPerPage);

        # log search (if this is a new search that has search parameters)
        if (isset($_GET["ST"]) && strlen($G_SearchGroupsForUrl))
        {
            $EventLog = new SPTEventLog();
            $EventType = ($_GET["ST"] == "Advanced") 
                    ? SPTEVENT_ADVANCEDSEARCH : SPTEVENT_SEARCH;
            $EventLog->Log($EventType, $G_SearchGroupsForUrl, $G_Engine->NumberOfResults());
        }
    }
	$_SERVER["SCRIPT_FILENAME"] = dirname(__FILE__)."/SPT--AdvancedSearch.php";
    # load up search results page
    include("include/SPT--StandardHtmlPageLoad.php");
}

?>
