<?php
#
#   FILE:  SPT--DBConfirmDeleteField.php
#
#   FUNCTIONS PROVIDED:
#       PrintFieldName()
#       - print field name
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print out field name
function PrintFieldName()
{
    global $Session;

    $F_FieldName = $Session->Get("F_FieldName");
    print $F_FieldName;
}

# see if this is the last tree field
function IsLastTreeField()
{
    global $Session;

    $F_FieldName = $Session->Get("F_FieldName");

    $Schema = new MetadataSchema();
    $Field = $Schema->GetFieldByName($F_FieldName);

    if ($Field->Type() & MDFTYPE_TREE)
    {
        $Fields = $Schema->GetFields(MDFTYPE_TREE);
        if (count($Fields) == 1)
            return TRUE;
    }
    return FALSE; 
}

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$F_FieldId = $Session->Get("F_FieldId");
$Session->PassVariable("F_FieldId", $F_FieldId);

PageTitle("Confirm Delete Database Field");
include("include/SPT--StandardHtmlPageLoad.php");

?>
