<?php

// includes/themes-genesis/items-genesis-divine

/**
 * Prevent direct access to this file.
 *
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Sorry, you are not allowed to access this file directly.' );
}


add_filter( 'tbex_filter_items_theme_customizer_deep', 'ddw_tbex_themeitems_divine_customize', 90 );
/**
 * Customize items for Genesis Child Theme:
 *   Divine (Premium, by Restored 316 Designs // Lauren Gaige)
 *
 * @since 1.4.2
 *
 * @param array $items Existing array of params for creating Toolbar nodes.
 * @return array Tweaked array of params for creating Toolbar nodes.
 */
function ddw_tbex_themeitems_divine_customize( array $items ) {

	/** Declare child theme's items */
	$divine_items = array(
		'colors' => array(
			'type'  => 'section',
			'title' => __( 'Colors', 'toolbar-extras' ),
			'id'    => 'divinetheme-colors',
		),
		'header_image' => array(
			'type'  => 'section',
			'title' => __( 'Header Image', 'toolbar-extras' ),
			'id'    => 'divinetheme-header-image',
		),
		'background_image' => array(
			'type'  => 'section',
			'title' => __( 'Background Image', 'toolbar-extras' ),
			'id'    => 'divinetheme-background-image',
		),
	);

	/** Merge and return with all items */
	return array_merge( $items, $divine_items );

}  // end function
